/*
local PANEL = {};

// link to class
function PANEL:LinkToClass( cls )
	self.LinkedClass = cls;
end


// window init.
function PANEL:Init( )
	//
	self.LinkedClass = nil;
	
	// label
	self.Label = vgui.Create( "Label", self );
	self.Label:SetMouseInputEnabled( false );
	
	// set reputation
	self.Reputation = 0;
end

// set text
function PANEL:SetText( txt )
	self.Label:SetText( txt );
	
end

// apply scheme settings
function PANEL:ApplySchemeSettings( )
	self.Label:SetFont( AppFramework:Theme().fonts['text'] );
	
	// rep color..
	local color = self:GetRepColor( 1, 1 );
	self.Label:SetFGColor( color );
	
end

// perform layout.
function PANEL:PerformLayout( )
	self.Label:SizeToContents();
	self.Label:SetPos( self:GetWide() * 0.5 - self.Label:GetWide() * 0.5, 4 );
	
	self:SetSize( self:GetWide(), 18 + 20 );
end

// get rep color
function PANEL:GetRepColor( i, c )
	local color;
	
	if( self.Reputation < -25 ) then
		// draw in reverse.
		color = Color(
			128 + ( ( math.abs( self.Reputation ) ) / c ) * i,
			128,
			128,
			255
		);
		
	elseif( self.Reputation > 25 ) then
		// draw in reverse.
		color = Color(
			128,
			128 + ( ( math.abs( self.Reputation ) ) / c ) * i,
			128,
			255
		);
	
	else
		// draw in reverse.
		color = Color(
			128,
			128,
			128,
			255
		);

	end
	return color;
end

// cursor enter/exit tooltips
function PANEL:OnCursorEntered( )
	// calculate tip.
	local tip = "Neutral";
	
	if( self.Reputation < -25 ) then
		tip = "Hostile";
		
	end
	
	if( self.Reputation < -85 ) then
		tip = "Extremely Hostile";
		
	end
	
	if( self.Reputation > 25 ) then
		tip = "Friendly";
		
	end
	
	if( self.Reputation > 75 ) then
		tip = "Very Friendly";
	
	end
	
	AppFramework:SetTooltip( tip );
end

function PANEL:OnCursorExited( )
	AppFramework:DestroyTooltip();
end

// paint.
function PANEL:Paint( )
	// frame
	AppFramework:Theme():DrawFrame( 0, 0, self:GetWide(), self:GetTall(), FRAME_INSET );
	
	// calculate the number of blocks.
	local count = math.floor( self:GetWide() / ( 8 + 2 ) ) - 2;
	local mid = math.floor( count / 2 );
	local pcount = math.abs( math.floor( ( mid / 127 ) * self.Reputation ) );
	
	// calculate start ofs.
	local ofs = self:GetWide() * 0.5 - ( count * 10 ) * 0.5;
	
	// update font color.
	local color = self:GetRepColor( 1, 1 );
	self.Label:SetFGColor( color );
	
	// draw rep.
	local i;
	for i = 0, pcount do
		// set color.
		local color = self:GetRepColor( i, pcount );
		surface.SetDrawColor(
			color.r,
			color.g,
			color.b,
			color.a
		);
		
		// negative?
		if( self.Reputation < 0 ) then
			local x = ofs - 4 + ( mid - i ) * 10;
			surface.DrawRect(
				x, 18,
				8, 16
			);
		
		// positive.
		else
			local x = ofs - 4 + ( mid + i ) * 10;
			surface.DrawRect(
				x, 18,
				8, 16
			);
		end
	end
	
	// draw borders.
	local color = AppFramework:CopyColor( AppFramework:Theme().colors['selection'] );
	for i = 0, count do
		// draw overlay bar.
		surface.SetDrawColor(
			color.r,
			color.g,
			color.b,
			40
		);
		
		local x = ofs - 4 + i * 10;
		surface.DrawOutlinedRect(
			x, 18,
			8, 16
		);
	end
	
	return true;
end

// register.
vgui.Register( "ctl_reputation", PANEL, "Button" );




// create app framework control.
CtlReputation_class 	= Control_class:create( nil, false, "ctl_reputation" );

// set text
function CtlReputation_class:SetText( txt )
	self:GetHandle():SetText( txt );

end
*/